<?php

namespace Orms\Test\Cache;

require_once __DIR__ .  '/../../Orms/Cache/CacheInterface.php';
require_once __DIR__ .  '/../../Orms/Cache/CacheKey.php';

use Orms\Cache\CacheInterface;
use Orms\Cache\CacheKey;

/**
 * Description of MemoryCache
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
class MemoryCache implements CacheInterface
{
    public $memory = array();

    public function clean(CacheKey $key)
    {
        unset($this->memory[$key->getKey()]);
    }

    public function get(CacheKey $key)
    {
        if(isset($this->memory[$key->getKey()]))
        {
            if(isset($this->memory[$key->getKey()][$key->getField()]))
            {
                return $this->memory[$key->getKey()][$key->getField()];
            }
        }

        return null;
    }

    public function set(CacheKey $key, $value, $metada)
    {
        $this->memory[$key->getKey()] =
            [
                $key->getField() =>
                [
                    $value,
                    $metada
                ]
            ];
    }
}
