<?php

namespace Orms\Type;

class PgArray extends Type implements TypeInterface
{
    /**
     * sets the value of the object after checking
     *
     * @param mixed $value
     *
     * @return object
     */

    public function setValue($value)
    {
        parent::setValue($value);

        $this->_decode($value);
    }

    /**
     * Gets an usable value of the object
     *
     * @return mixed
     */

    public function getValue()
    {
        return $this->_value;
    }

    /**
     * Convert to a valid pg string for arrays
     *
     * @return string
     */

    public function __toString()
    {
        $returnArray = array();

        foreach ($this->_value as $v)
        {
            $v = 
                str_replace(
                    array('"', '{', '}'),
                    array('\\"', '\\{', '\\}'), 
                    $v
                );

            if (preg_match('/[,\s]/', $v, $m) or ($v === ''))
            {
                $v = '"' . $v . '"';
            }

            $returnArray[] = $v;
        }

        return '{' . implode(',', $returnArray) . '}';
    }

    /**
     * Checks if the value provided is valid
     *
     * @param mixed $value
     *
     * @returns boolean
     */

    public function isValid($value)
    {
        // $value must be a string or an array
        // If it's a string, it must begin with '{' and ends with '}'

        if (is_array($value))
        {
            return true;
        }
        
        if (is_string($value))
        {
            if (
                    ('{' === mb_substr($value, 0, 1))
                    and
                    ('}' === mb_substr($value, -1, 1))
            )
            {
                return true;
            }
        }

        return false;
    }

    /**
     * recursive Parsing method
     *
     * @param string      $value
     * @param array      &$output
     * @param bool/int    $limit
     * @param integer     $offset
     *
     * @return array
     */

    private function _decode(
        $value,
        &$output = array(),
        $limit = false,
        $offset = 1
    )
    {
        // If it's an array, we ignore the keys.
        
        if (is_array($value))
        {
            foreach ($value as $k => $v)
            {
                $output[] = $v;
            }
        }
        else // It's a string
        {
            if ($limit === false)
            {
                $limit = strlen($value) - 1;
                $output = array();
            }
    
            if ($value != '{}')
            {
                do
                {
                    if ($value{$offset} != '{')
                    {
                        preg_match(
                            "/(\\{?\"([^\"\\\\]|\\\\.)*\"|[^,{}]+)+([,}]+)/",
                            $value,
                            $match,
                            0,
                            $offset
                        );
    
                        $offset += strlen($match[0]);
    
                        $output[] =
                            (
                                $match[1]{0} != '"'
                                    ?
                                    $match[1]
                                    :
                                    stripcslashes(mb_substr($match[1], 1, -1))
                            );
    
                        if ($match[3] == '},')
                        {
                            return $offset;
                        }
                    }
                    else
                    {
                        $offset =
                            $this->_decode(
                                $value,
                                $output[],
                                $limit,
                                $offset + 1
                            );
                    }
                }
                while ($limit > $offset);
            }
        }
        
        $this->_value = new \ArrayObject($output);
        // TODO : Missing return statement
    }

}
