<?php

namespace Orms\Test\Mock;

use Orms\Object\DataObject;

class ConcreteDataObject extends DataObject
{
    static protected $_pkFields =
        array(
            'col1'
        );

    static protected $_columns =
        array(
            'col1' =>
                array(
                    'type' => 'integer'
                ),
            'col2' =>
                array(
                    'type' => 'string'
                ),
            'col3' =>
                array(
                    'type'      => 'hstore',
                    'default'   => ''
                ),
            'col4' =>
                array(
                    'type'      => 'xml',
                    'default'   => '<data />'
                ),
            'col5' =>
                array(
                    'type'      => 'date',
                    'default'   => "now"
                ),
            'col5_1' =>
                array(
                    'type'      => 'date_time',
                    'default'   => "now"
                ),
            'col5_2' =>
                array(
                    'type'      => 'time',
                    'default'   => "now"
                ),
            'col6' =>
                array(
                    'type'      => 'pg_array',
                    'default'   => "{}"
                )
        );

    public function getValues() { return $this->_string_values; }

    /**
     * find method
     */

    static public function find(
        $provider,
        Array $params = array(),
        Array $links = null)
    {
        $result = new \ArrayIterator();

        $result->append(new ConcreteDataObject(
                $provider,
                $params
            ));

        return $result;
    }
}
