<?php

namespace Orms\Type;

use Orms\Type\Exception;

class MsBinary extends Type implements TypeInterface
{
    /**
     * sets the value of the object after checking
     *
     * @param mixed $value
     * @return void
     * @throws Exception
     */
    public function setValue($value)
    {
        if (is_null($value)) {
            $this->_value = null;
        } elseif (false === $this->isValid($value)) {
            throw new Exception(
                'Can\'t set a ' . static::class . ' object with the ' .
                'value [' . print_r($value, true) . ']'
            );
        } else {
            $this->_value = $value;
        }
    }

    /**
     * Checks if the value provided is valid
     *
     * @param mixed $value
     *
     * @returns boolean
     */
    public function isValid($value)
    {
        return is_string($value);
    }

    /**
     * Returns a string version of the object
     *
     * @return string
     */
    public function __toString()
    {
        return $this->_value;
    }
}
