<?php

namespace Orms\Tests\Proxy;

use Orms\Proxy\Dumper\ProxyDumper;
use Orms\Proxy\Manager;
use Orms\Proxy\Registry;
use Orms\Tests\Mock\ProxyTestService;
use PHPUnit\Framework\TestCase;

class ProxyDirectMethodTest extends TestCase
{
    private $cacheDir;

    protected function setUp()
    {
        $this->cacheDir = '/tmp/orms-proxies';
    }

    public function testDirectProxy()
    {
        $manager = $this->getConfiguredManager([
            'direct' => ['getDirectValue' => ['test_service', 'getValue']],
            'fetcher' => ['fetchValue' => ['test_service', 'getValue', 'setFetchedValue']],
            'uncached' => ['getUncachedValue' => ['test_service', 'getValue']]
        ]);

        $entity = new \Proxies\ProxyTestEntity(null, $manager->getRegistry());

        // On each hit on the service its return value increases by 1.
        // There is also an offset (the argument of the getter/fetcher)
        $this->assertSame(0 + 0, $entity->getDirectValue());
        $this->assertSame(0 + 0, $entity->getDirectValue()); // Cache will return previous value. No hit.

        $this->assertSame(1 + 1, $entity->fetchValue(1)->getFetchedValue());
        $this->assertSame(2 + 3, $entity->fetchValue(3)->getFetchedValue());

        $this->assertSame(3 + 0, $entity->getUncachedValue());
        $this->assertSame(4 + 1, $entity->getUncachedValue(1));
    }

    public function getConfiguredManager(array $proxiesConfig)
    {
        $config = $this
            ->getMockBuilder('AlloCine\OrmsBundle\Config\ObjectWrapper')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $provider = $this
            ->getMockBuilder('Orms\DataProvider\GenericDataProvider')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $config
            ->expects($this->any())
            ->method('getProvider')
            ->willReturn($provider)
        ;

        $registry = new Registry();
        $registry->set('proxy_test_entity.config', $config);
        $registry->set('test_service', new ProxyTestService());
        $registry->set('entity.provider', $provider);
        $registry->set('entity.links', []);

        $dumper = new ProxyDumper();
        $manager = new Manager($dumper, $registry, $this->cacheDir, true);

        $manager->setConfig([
            'objects' => [
                'ProxyTestEntity' => [
                    'object_class' => 'Orms\Tests\Mock\ProxyTestEntity',
                    'proxies' => $proxiesConfig
                ]
            ]
        ]);

        $manager->boot();

        return $manager;
    }

    protected function tearDown()
    {
        if (file_exists($this->cacheDir)) {
            unlink($this->cacheDir);
        }
    }
}
