<?php

namespace Orms\Proxy\Dumper;

class FetcherMethodDumper extends AbstractMethodDumper implements MethodDumperInterface
{
    const METHOD_TEMPLATE = <<<EOF
    %visibility% function %method% (%arguments%) {
        \$this->%setter%(\$this->registry->get('%service%')->%service_method%(%arguments_short%));

        return \$this;
    }
EOF;

    /**
     * @var string
     */
    private $serviceName;

    /**
     * @var string
     */
    private $serviceMethod;

    /**
     * @var string
     */
    private $setter;

    /**
     * @param string $serviceName
     * @param string $serviceMethod
     * @param string $setter
     */
    public function __construct($serviceName, $serviceMethod, $setter)
    {
        $this->serviceName   = $serviceName;
        $this->serviceMethod = $serviceMethod;
        $this->setter        = $setter;
    }

    /**
     * {@inheritsDoc}
     */
    public function dump(\ReflectionMethod $method, $configName)
    {
        $argumentsShort = $this->dumpParameters($method->getParameters(), false);

        return str_replace(
            [
                '%setter%',
                '%visibility%',
                '%method%',
                '%arguments%',
                '%arguments_short%',
                '%service%',
                '%service_method%',
            ],
            [
                $this->setter,
                $this->getVisibility($method),
                $method->name,
                $this->dumpParameters($method->getParameters()),
                '$this' . (!empty($argumentsShort) ? ', ' . $argumentsShort : ''),
                $this->serviceName,
                $this->serviceMethod
            ],
            self::METHOD_TEMPLATE
        );
    }
}
