<?php

namespace Orms\Middleware;

class CacheResult
{
    /**
     * @var mixed
     */
    protected $result;

    /**
     * @var mixed
     */
    protected $metadata;

    /**
     * @var string
     */
    protected $query;

    /**
     * @param mixed $result
     * @param mixed $metadata
     * @param string $query
     */
    public function __construct($result, $metadata, $query = null)
    {
        $this->result = $result;
        $this->metadata = $metadata;
        $this->query = $query;
    }

    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @return mixed
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /**
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }
}
