<?php

namespace Orms\Test;

use Orms\Type\FloatType;

class FloatTypeTest extends \PHPUnit_Framework_TestCase
{
	public function testConstruct1()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t create a Orms\Type\FloatType object with a null value.'
		);
	
		$i = new FloatType();
	}

	public function testConstruct2()
	{
		$i = new FloatType(12.5);

		$this->assertSame(12.5, $i->getValue());
		$this->assertSame('12.5', $i->__toString());
	}

	public function testConstruct3()
	{
		$i = new FloatType('12.5');

		$this->assertSame(12.5, $i->getValue());
		$this->assertSame('12.5', $i->__toString());
	}

	public function testConstruct4()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\FloatType object with the value [12,5]'
		);
	
		$i = new FloatType('12,5');
	}
	
	public function testConstruct5()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\FloatType object with the value [Array
(
    [0] => 12
)
]'
		);
	
		$i = new FloatType(array(12));
	}	
}