<?php

namespace Orms\Statement;

use Orms\Statement\Statement;
use Orms\Exception\SqlExceptionInterface;

/**
 * MysqlStatement
 *
 * Représente une requête PostgreSQL préparée et, une fois exécutée,
 * le jeu de résultats associé.
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
class PostgresqlStatement extends Statement implements SqlExceptionInterface
{
    /**
     * {@inheritDoc}
     */
    public function rowCount()
    {
        return pg_num_rows($this->resource);
    }

    /**
     * {@inheritDoc}
     */
    public function fetch($style = self::FETCH_ASSOC, $index = null)
    {
        if(!is_null($index))
        {
            pg_result_seek($this->resource, $index);
        }

        switch($style)
        {
            case self::FETCH_OBJ:
                return pg_fetch_object($this->resource);

            case self::FETCH_NUM:
                return pg_fetch_row($this->resource);

            case self::FETCH_ASSOC:
            default:
                return pg_fetch_assoc($this->resource);
        }
    }

    /**
     * {@inheritDoc}
     */
    public function execute($params)
    {
        $result = @pg_execute($this->connectionRessource, $this->id, $params);

        if(false !== $result)
        {
            $this->resource = $result;

            return true;
        }
        else
        {
            return false;
        }
    }

    /**
     * {@inheritDoc}
     */
    public function errorCode()
    {
        return null;
    }

    /**
     * {@inheritDoc}
     */
    public function errorInfo()
    {
        return pg_last_error($this->connectionRessource);
    }

    /**
     * {@inheritDoc}
     */
    public function __destruct()
    {
        if(is_resource($this->resource))
        {
            return pg_free_result($this->resource);
        }
    }
}
