<?php

namespace Orms\Statement;

use Orms\Statement\Statement;
use Orms\Exception\SqlExceptionInterface;

class MssqlStatement extends Statement implements SqlExceptionInterface
{
    /**
     * @var \PDOStatement
     */
    private $statement;

    /**
     * @var \PDO
     */
    private $connection;

    /**
     * @var mixed
     */
    private $currentData;

    /**
     * @param \PDOStatement $statement
     */
    public function __construct(\PDO $connection, \PDOStatement $statement)
    {
        $this->connection  = $connection;
        $this->statement   = $statement;
        $this->currentData = false;
    }

    /**
     * Not implemented because : http://stackoverflow.com/questions/30094744/pdo-dblib-mssql-more-statements-error
     */
    public function rowCount()
    {
        throw new \RuntimeException('rowCount is unsupported for SQL Server.');
    }

    /**
     * {@inheritDoc}
     */
    public function current()
    {
        if ($this->currentData === false) {
            $this->currentData = parent::current();
        }

        return $this->currentData;
    }

    /**
     * {@inheritDoc}
     */
    public function next()
    {
        parent::next();
        $this->currentData = parent::current();
    }

    /**
     * @return {@inheritDoc}
     */
    public function valid()
    {
        return false !== $this->current();
    }

    /**
     * {@inheritDoc}
     */
    public function fetch($style = self::FETCH_ASSOC, $index = null)
    {
        $cursorMode = $index !== null ? \PDO::FETCH_ORI_ABS : \PDO::FETCH_ORI_NEXT;

        return $this->statement->fetch($style, $cursorMode, $index);
    }

    /**
     * {@inheritDoc}
     */
    public function execute($params)
    {
        return $this->statement->execute($params);
    }

    /**
     * {@inheritDoc}
     */
    public function errorCode()
    {
        return $this->statement->errorCode();
    }

    /**
     * {@inheritDoc}
     */
    public function errorInfo()
    {
        return $this->statement->errorInfo();
    }

    /**
     * {@inheritDoc}
     */
    public function __destruct()
    {
        $this->statement = null;

        return true;
    }
}
