<?php

namespace Orms\Test;

require_once(__DIR__ . '/../../Orms/Tools/SimpleXMLElementExtended.php');

use Orms\Tools\SimpleXmlElementExtended;

/**
 * @group SimpleXmlElementExtended
 */

class SimpleXmlElementExtendedTest extends \PHPUnit_Framework_TestCase
{
	public function testMerge1()
	{
		$global =
'<?xml version="1.0" ?>
<settings>
    <comment>
        <allowed>1</allowed>
        <moderation>0</moderation>
    </comment>
</settings>
';

		$add =
'<?xml version="1.0" ?>
<settings>
    <comment>
        <allowed>0</allowed>
    </comment>
</settings>
';
		
		$xml 	= new SimpleXmlElementExtended($global);
		$addXml = new SimpleXmlElementExtended($add);
		
		$xml->merge($addXml);

		$expected =
'<?xml version="1.0"?>
<settings>
    <comment>
        <allowed>0</allowed>
        <moderation>0</moderation>
    </comment>
</settings>
';

		$this->assertEquals($expected, $xml->asXML());
	}
	
	public function testDiff1()
	{
		$global =
'<?xml version="1.0" ?>
<settings>
    <comment>
        <allowed>1</allowed>
        <moderation>0</moderation>
    </comment>
</settings>
';

		$diff =
'<?xml version="1.0"?>
<settings>
    <comment>
        <allowed>0</allowed>
        <moderation>0</moderation>
    </comment>
</settings>
';
		
		$xml 	= new SimpleXmlElementExtended($global);
		$diffXml = new SimpleXmlElementExtended($diff);
		
		$expected =
'<?xml version="1.0"?>
<settings><comment><allowed>0</allowed></comment></settings>
';

		$this->assertEquals($expected, $xml->diff($diffXml)->asXml());
	}
	
	public function testDiff2()
	{
		$global =
'<?xml version="1.0" ?>
<settings>
    <comment>
        <allowed>1</allowed>
        <moderation>0</moderation>
    </comment>
</settings>
';

		$diff =
'<?xml version="1.0"?>
<settings>
    <comment>
        <allowed>1</allowed>
        <moderation>0</moderation>
    </comment>
</settings>
';
		
		$xml 	= new SimpleXmlElementExtended($global);
		$diffXml = new SimpleXmlElementExtended($diff);
		
		$expected =
'<?xml version="1.0"?>
<settings/>
';

		$this->assertEquals($expected, $xml->diff($diffXml)->asXml());
	}	
}