<?php

namespace Orms\Connection;

use Orms\Connection\OrmsPDO;

class Mysql extends OrmsPDO
{
    /**
     * Open a new MySQL OrmsPDO connection
     * @param array $options
     * @return \PDO
     * @throws \Exception
     */
    public function __construct($options = array())
    {
        if (!isset($options['dsn']))
        {
            throw new \Exception('DSN option must be set for class '.__CLASS__);
        }
        
        $username = isset($options['username']) ? $options['username'] : null;
        $password = isset($options['password']) ? $options['password'] : null;
        
        // General options
        $driverOptions = 
            isset($options['driver_options']) 
            ? 
            $options['driver_options'] 
            : 
            array();
        
        // MySQL Specific options
        $driverOptions['utf8'] = 
            (isset($options['utf8']) && true === $options['utf8']) 
            ? 
            true 
            : 
            false;

        return parent::__construct(
                $options['dsn'], 
                $username, 
                $password, 
                $this->buildDriverOptions($driverOptions)
            );
    }
    
    /**
     * Build PDO drivers options
     * @param array $options
     * @return array
     */
    protected function buildDriverOptions($options = array())
    {
        $driverOptions = parent::buildDriverOptions($options);
        
        // MySQL UTF-8 enable
        if(true === $options['utf8'])
        {
            $driverOptions[\PDO::MYSQL_ATTR_INIT_COMMAND] = 'SET NAMES utf8';
        }

        return $driverOptions;
    }
}

