<?php

namespace Orms\Test;

require_once(__DIR__ . '/../../Orms/Type/Type.php');
require_once(__DIR__ . '/../../Orms/Type/Exception.php');
require_once(__DIR__ . '/../../Orms/Type/Float.php');

use Orms\Type\Float;

class FloatTest extends \PHPUnit_Framework_TestCase
{
	public function testConstruct1()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t create a Orms\Type\Float object with a null value.'
		);
	
		$i = new Float();
	}

	public function testConstruct2()
	{
		$i = new Float(12.5);

		$this->assertSame(12.5, $i->getValue());
		$this->assertSame('12.5', $i->__toString());
	}

	public function testConstruct3()
	{
		$i = new Float('12.5');

		$this->assertSame(12.5, $i->getValue());
		$this->assertSame('12.5', $i->__toString());
	}

	public function testConstruct4()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Float object with the value [12,5]'
		);
	
		$i = new Float('12,5');
	}
	
	public function testConstruct5()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Float object with the value [Array
(
    [0] => 12
)
]'
		);
	
		$i = new Float(array(12));
	}	
}