<?php

namespace Orms\Type;

class Json extends Type implements TypeInterface
{
    /**
     * sets the value of the object after checking
     *
     * @param mixed $value
     *
     * @return object
     */

    public function setValue($value)
    {
        if (is_null($value)) {
            $value = '{}';
        }

        parent::setValue($value);

        $this->_decode($value);
    }

    /**
     * Gets an usable value of the object
     *
     * @return mixed
     */

    public function getValue()
    {
        if (is_null($this->_value)) {
            $this->_value = new \StdClass();
        }

        return $this->_value;
    }

    /**
     * Convert to a valid pg string for arrays
     *
     * @return string
     */

    public function __toString()
    {
        return json_encode($this->_value);
    }

    /**
     * Checks if the value provided is valid
     *
     * @param mixed $value
     *
     * @returns boolean
     */

    public function isValid($value)
    {
        return (! is_null(@json_decode($value)));
    }

    /**
     * Parsing method
     *
     * @param string      $value
     *
     * @return void
     */

    protected function _decode($value)
    {
        $this->_value = @json_decode($value);
    }


    /**
     * __unset
     *
     * The magic unsetter (including constraint on attributes)
     *
     * @param string $name
     * @param mixed  $value
     *
     * @return void
     */

    public function __unset($name)
    {
        if (is_string($name) && isset($this->_value->{$name})) {
            unset($this->_value->{$name});
        }
    }

    /**
     * __set
     *
     * The magic setter (including constraint on attributes)
     *
     * @param string $name
     * @param mixed  $value
     *
     * @return void
     */

    public function __set($name, $value)
    {
        if (is_string($name)) {
            $this->_value->{$name} = $value;
        }
    }

    /**
     * __get
     *
     * The magic getter
     *
     * @param string $name
     *
     * @return mixed
     */

    public function __get($name)
    {
        if (is_string($name)) {
            if (isset($this->_value->{$name})) {
                return $this->_value->{$name};
            }
        }

        return null;
    }

    /**
     * __isset
     *
     * @param string $name
     *
     * @return mixed
     */

    public function __isset($name)
    {
        return isset($this->_value->{$name});
    }
}
