<?php

namespace Orms\Type;

/**
 * Class for float typing
 *
 * Because of PHP7 reserved the keyword "float", the Float class is renamed
 * FloatType
 */

class FloatType extends Type implements TypeInterface
{
    /**
     * sets the value of the object after checking
     *
     * @param mixed $value
     *
     * @return object
     */

    public function setValue($value)
    {
        parent::setValue($value);

        $this->_value = floatval($value);
    }

    /**
     * Checks if the value provided is valid
     *
     * @param mixed $value
     *
     * @returns boolean
     */

    public function isValid($value)
    {
        return
            (
                is_float($value) ||
                (
                    is_numeric($value)
                    &&
                    ($value == floatval($value))
                )
            );
    }

    /**
     * Returns a string version of the object
     *
     * @return string
     */

    public function __toString()
    {
        return strval($this->_value);
    }
}
