<?php

namespace Orms\Tests\Type;

use Orms\Type\Time;

class TimeTest extends \PHPUnit_Framework_TestCase
{
    public function testConstruct1()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t create a Orms\Type\Time object with a null value.'
        );

        $d = new Time();
    }

    public function testConstruct2()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\Time object with the value [Coin]');

        $d = new Time('Coin');
    }

    public function testConstruct3()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\Time object with the value [12.5]');

        $d = new Time(12.5);
    }

    public function testConstruct4()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\Time object with the value [12]');

        $d = new Time(12);
    }

    public function testConstruct5()
    {
        $this->setExpectedException(
            'Orms\Type\Exception',
            'Can\'t set a Orms\Type\Time object with the value [Array
(
    [0] => 12
)
]'
        );

        $d = new Time([12]);
    }

    public function testConstruct8()
    {
        $d = new Time('now');

        $this->assertEquals(date('H:i:s'), $d->__toString());
    }

    public function testConstruct9()
    {
        $d = new Time('12:13:14');

        $this->assertEquals(date('H:i:s', strtotime('12:13:14')), $d->__toString());
    }
}
