<?php

namespace Orms\Logger;

/**
 * Description of LoggerInterface
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
interface LoggerInterface
{
    /**
     * Log query start
     * @param string $sql
     * @param array $params
     * @param array $types
     */
    public function startQuery($sql, array $params = null, array $types = null);

    /**
     * Stop query logging
     * @param boolean $cached
     * @param int $rows
     */
    public function stopQuery($cached = false, $rows = 0);

    /**
     * Logs a message.
     *
     * @param string $message A message to log
     */
    public function log($message);

    /**
     * Logs an exception
     *
     * @param string $message A message to log
     */
    public function logException($message);

    /**
     * Return last executed query
     *
     * @return string
     */
    public function getLastExecutedQuery();
}
