<?php

namespace Orms\Connection;

use Orms\Exception\SqlExceptionInterface;

/**
 * Description of SqlInterface
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
interface SqlInterface extends SqlExceptionInterface
{
    /**
     * Ping la connexion à la base
     *
     * @return boolean
     */
    public function ping();

    /**
     * Protège une chaîne de caractères pour une requête SQL
     *
     * @param string $data
     * @return string
     */
    public function quote($data);

    /**
     * Exécute une requête
     *
     * @param string $sql
     * @return \Orms\Statement\PostgresqlStatement|boolean
     */
    public function query($sql);

    /**
     * Envoie une requête pour créer une requête préparée avec les paramètres
     * donnés et attend l'exécution
     *
     * @param string $sql
     * @return \Orms\Statement\PostgresqlStatement|boolean
     */
    public function prepare($sql);

    /**
     * Exécute une requête SQL et retourne le nombre de lignes affectées
     *
     * @param string $sql
     * @return int|boolean
     */
    public function exec($sql);

    /**
     * Termine une connexion
     *
     * @return boolean
     */
    public function __destruct();

    /**
     * Start transaction
     * @return mixed
     */
    public function beginTransaction();

    /**
     * commit to connection
     * @return mixed
     */
    public function commit();

    /**
     * rollback last transaction
     * @return mixed
     */
    public function rollback();
}
