<?php

namespace Orms\Test;

require_once(__DIR__ . '/../../Orms/Type/Type.php');
require_once(__DIR__ . '/../../Orms/Type/Exception.php');
require_once(__DIR__ . '/../../Orms/Type/Hstore.php');

use Orms\Type\Hstore;

class HstoreTest extends \PHPUnit_Framework_TestCase
{
	public function testConstruct1()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t create a Orms\Type\Hstore object with a null value.'
		);
	
		$h = new Hstore();
	}

	public function testConstruct2()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Hstore object with the value [Coin]');
		
		$h = new Hstore('Coin');
	}

	public function testConstruct3()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Hstore object with the value [12.5]');
		
		$h = new Hstore(12.5);
	}

	public function testConstruct4()
	{

		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Hstore object with the value [12]');
		
		$h = new Hstore(12);
	}
	
	public function testConstruct5()
	{
		$h = new Hstore(array(12));
		
		$this->assertEquals(1, count($h->toArray()));
		$this->assertEquals(array('0' => '12'), $h->toArray());
	}
	
	public function testConstruct6()
	{
		$this->setExpectedException(
			'Orms\Type\Exception',
			'Can\'t set a Orms\Type\Hstore object with the value [' .
				'"COIN"=>truc]'
		);
	
		$h = new Hstore('"COIN"=>truc');
	}

	public function testConstruct7()
	{
		$h = new Hstore('');
		
		$this->assertEquals(0, count($h->toArray()));
	}
	
	public function testGetValue()
	{
		$h = new Hstore('"COIN"=>"truc"');

		$this->assertInstanceOf('\Orms\Type\Hstore', $h->getValue());
		$this->assertEquals(new Hstore('"COIN"=>"truc"'), $h->getValue());
		$this->assertEquals(array('COIN' => 'truc'), $h->toArray());

		$this->assertEquals('truc', $h->COIN);
		$this->assertNull($h->PAN);
		$this->assertTrue(isset($h->COIN));
		$this->assertFalse(isset($h->PAN));
		
		$h->PAN = 'ouille';

		$this->assertEquals('truc', $h->COIN);
		$this->assertEquals('ouille', $h->PAN);
		$this->assertEquals(
			array(
				'COIN' => 'truc',
				'PAN' => 'ouille'
			),
			$h->toArray()
		);
		$this->assertEquals('"COIN"=>"truc","PAN"=>"ouille"', $h->__toString());
		$this->assertTrue(isset($h->COIN));
		$this->assertTrue(isset($h->PAN));
		
		unset($h->COIN);

		$this->assertNull($h->COIN);
		$this->assertEquals('ouille', $h->PAN);
		$this->assertEquals(
			array(
				'PAN' => 'ouille'
			),
			$h->toArray()
		);
		$this->assertEquals('"PAN"=>"ouille"', $h->__toString());
		$this->assertFalse(isset($h->COIN));
		$this->assertTrue(isset($h->PAN));
	}
}