<?php

namespace Orms\Test\Cache;

require_once 'TestDataProvider.php';
require_once 'MemoryCache.php';
require_once 'Logger.php';
require_once __DIR__ . '/../MockClasses.php';
require_once(__DIR__ . '/../../Orms/Type/DateType.php');
require_once(__DIR__ . '/../../Orms/Type/Time.php');
require_once(__DIR__ . '/../../Orms/Type/DateTime.php');
require_once(__DIR__ . '/../../Orms/Type/Date.php');
require_once(__DIR__ . '/../../Orms/Type/Integer.php');

use Orms\Test\Cache\TestDataProvider;
use Orms\Test\Cache\MemoryCache;
use Orms\Test\Cache\Logger;
use \ConcreteDataObject;
use Orms\Type\Date;
use Orms\Type\DateType;
use Orms\Type\DateTime;
use Orms\Type\Integer;

/**
 * Description of CacheTest
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
class CacheTest extends \PHPUnit_Framework_TestCase
{
    protected $cache;

    public function testCache()
    {
        $provider = $this->loadDataProvider();

        $this->assertTrue($provider->isCacheable());

        $this->assertEquals(
            $provider->get(array('col1' => 1, '_private' => 2)),
            ['URL' => 'http://test']
        );

        $this->assertEquals(
            $provider->getMetadata(),
            ['META' => 1]
        );

        // Check Cache
        $this->assertEquals(
            $this->cache->memory,
            [
                1 =>
                [
                    'Orms\Test\Cache\TestDataProvider42f52ce80af87a68ff0d9ce2918e7f7380cbf8a6' =>
                    [
                        ['URL' => 'http://test'],
                        ['META' => 1]
                    ]
                ]
            ]
        );

        // Change cache memory
        $this->cache->memory =
        [
            1 =>
            [
                'Orms\Test\Cache\TestDataProvider42f52ce80af87a68ff0d9ce2918e7f7380cbf8a6' =>
                [
                    ['URL' => 'http://URL'],
                    ['META' => 2]
                ]
            ]
        ];

        // Check Cache again to be sure to have same result
        $this->assertEquals(
            $provider->get(array('col1' => 1, '_private' => 2)),
            ['URL' => 'http://URL']
        );

        $this->assertEquals(
            $provider->getMetadata(),
            ['META' => 2]
        );

        // Now Clean Cache on save
        $obj = new ConcreteDataObject($provider);
        $obj->col1 = 1;

        $obj->save();

        $this->assertEquals($this->cache->memory, []);

        // Set Cache Again
        $this->assertEquals(
            $provider->get(array('col1' => 1, '_private' => 2)),
            ['URL' => 'http://test']
        );

        $this->assertNotEquals($this->cache->memory, []);

        // Now Clean Cache on delete
        $obj->delete();

        $this->assertEquals($this->cache->memory, []);
    }

    protected function loadDataProvider()
    {
        $this->cache = new MemoryCache();

        return new TestDataProvider
        (
            null,
            array(),
            null,
            new Logger(),
            $this->cache,
            [
                'ConcreteDataObject' => ['Orms\Test\Cache\TestDataProvider']
            ]
        );
    }
}
