<?php

namespace Orms\Test\Cache;

require_once __DIR__ .  '/../../Orms/DataProvider/GenericDataProvider.php';
require_once __DIR__ .  '/../../Orms/DataProvider/CacheableInterface.php';

use Orms\DataProvider\GenericDataProvider;
use Orms\DataProvider\CacheableInterface;

/**
 * Description of TestDataProvider
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
class TestDataProvider extends GenericDataProvider implements CacheableInterface
{
    public function setup($options)
    {

    }

    public function delete(array $definition, array $values)
    {
        return true;
    }

    public function insert(array $definition, array $values)
    {
        return
        [
            'col1' => $values['col1']
        ];
    }

    public function update(array $definition, array $values)
    {
        return
        [
            'col1' => $values['col1']
        ];
    }

    public static function getCacheProperty()
    {
        return 'col1';
    }

    static protected function getComposer($params)
    {
        static::$_meta[get_called_class()] = ['META' => 1];

        return ['URL' => 'http://test'];
    }
}
