<?php

namespace Orms\Type;

use Orms\Type\Exception;

/**
 * Class for string typing
 */

class String extends Type implements TypeInterface
{
    /**
     * sets the value of the object after checking
     *
     * @param mixed $value
     *
     * @return object
     */

    public function setValue($value)
    {
        if (is_null($value))
        {
            $this->_value = null;
        }
        elseif (false === $this->isValid($value))
        {
            throw new Exception(
                'Can\'t set a ' . get_called_class() . ' object with the ' .
                'value [' . print_r($value, true) . ']'
            );
        }
        else
        {
            $this->_value = strval($value);
        }
    }

    /**
     * Checks if the value provided is valid
     *
     * @param mixed $value
     *
     * @returns boolean
     */

    public function isValid($value)
    {
        return
            ! is_array($value)
            &&
            (
                is_string($value)
                ||
                (! is_object($value) && $value == strval($value))
                ||
                (
                    is_object($value)
                    &&
                    function_exists('__toString')
                    &&
                    $value == strval($value)
                )
            )
        ;
    }

    /**
     * Returns a string version of the object
     *
     * @return string
     */

    public function __toString()
    {
        return $this->_value;
    }
}