<?php

namespace Orms\Statement;

use Orms\Statement\Statement;
use Orms\Exception\SqlExceptionInterface;

use Orms\Exception\DatabaseException;

/**
 * MysqlStatement
 *
 * @author Yannick Le Guédart <xavier.hausherr@ebuzzing.com>
 */

class MssqlStatement extends Statement implements SqlExceptionInterface
{
    /**
     * {@inheritDoc}
     */

    public function rowCount()
    {
        return mssql_num_rows($this->resource);
    }

    /**
     * {@inheritDoc}
     */

    public function fetch($style = self::FETCH_ASSOC, $index = null)
    {
        if (! is_null($index))
        {
            mssql_data_seek($this->resource, $index);
        }

        switch ($style)
        {
            case self::FETCH_OBJ:
                return mssql_fetch_object($this->resource);

            case self::FETCH_NUM:
                return mssql_fetch_row($this->resource);

            case self::FETCH_ASSOC:
            default:
                return mssql_fetch_assoc($this->resource);
        }
    }

    /**
     * {@inheritDoc}
     */
    public function execute($params)
    {
        throw new DatabaseException(
            "MsSQL can't use deal with prepared requests."
        );
    }

    /**
     * {@inheritDoc}
     */

    public function errorCode()
    {
        return null;
    }

    /**
     * {@inheritDoc}
     */

    public function errorInfo()
    {
        return mssql_get_last_message($this->connectionRessource);
    }

    /**
     * {@inheritDoc}
     */

    public function __destruct()
    {
        if (is_resource($this->resource))
        {
            return mssql_free_result($this->resource);
        }

        return true;
    }
}
