<?php

/**
 * File ThriftLinked
 *
 * @package    Orms
 * @subpackage DataObject
 * @version    1.0
 * @author     Yannick Le Guédart
 */

namespace Orms\Object;

/**
 * Trait ThriftLinkedDataObject
 *
 * This class defines orms model objects that are somehow linked to a thrift
 * definition. It defines two abstract methods that have to be implemented
 * in order to convert to and be converted from the thrift object
 *
 * @package    Orms
 * @subpackage DataObject
 * @author     Yannick Le Guédart
 */

trait ThriftLinked
{
    /**
     * @var string $_thriftException name of the thrift exception class
     */

    // protected $_thriftException;

    /**
     * @var string $_thriftErrorCode name of the thrift error codes class
     */

    // protected $_thriftErrorCode;

    /**
     * Produces a thrift object  from the data object
     *
     * @return object Thrift object associated with the current object
     */

    abstract public function toThriftObject();

    /**
     * Sets the dataobject from a thrift object
     *
     * @param object $to The thrift object
     */

    abstract public function setFromThriftObject($to);

    /**
     * Throws a thrift exception exception
     *
     * @param int $code exception number in the $_thriftErrorCode class
     *
     * @throws Exception
     */

    public function throwThriftException($code)
    {
        $errorCodeClass = $this->_thriftErrorCode;

        throw new $this->_thriftException(
            [
                'code'    => $code,
                'message' => ($errorCodeClass::$_errorMessage[$code])
            ]
        );
    }
}
