<?php

/**
 * File LimitedQueue Trait
 *
 * @package   Orms
 * @version   1.0
 * @author    Yannick Le Guédart
 * @copyright 2013 Overblog
 */

namespace Orms\Object;

/**
 * Class LimitedQueue Trait
 *
 * @package    Orms
 * @subpackage Object
 * @author     Yannick Le Guédart
 */

trait LimitedQueue
{
    /** Name of the Orms element class (in the config file) */

    // protected $_ormsClassName = null;

    /** Maximum size of each limit according to the key */

    // protected $_queueSize = null;

    /** @var $_queueKey key to split queues */

    // protected $_queueKey = [];

    /** @var $_queueOrder Order inside a queue */

    // protected $_queueOrder = [];

    /**
     * If the save is successfull, we delete the last element of the queue if
     * we have too many entries
     *
     * @return bool
     */

    public function save()
    {
        /** @var Handlign the key params */

        $keyParams = [];

        foreach ($this->_queueKey as $v) {
            $keyParams[$v] = $this->{$v};
        }

        $itemCount =
            $this
                ->getExternalContext()
                ->get('orms')
                ->getNbObjects(
                    $this->_ormsClassName,
                    $keyParams
                );

        /** @var Trying to save the object (&& store the result) */

        $r = parent::save();

        /** Poping out excess elements */

        if (($itemCount + intval($r)) > $this->_queueSize) {
            $this->_popElements(
                ($itemCount + intval($r)) - $this->_queueSize
            );
        }

        /** && return the save result */

        return $r;
    }

    /**
     * Pop $n elements from the queue
     *
     * @param int $n
     */

    protected function _popElements($n)
    {
        /** @var $params handling reverse order param*/

        $params =
            [
                'offset' => 0,
                'limit'  => $n,
                'order'  =>
                    array_map(
                        function ($v) { return (! $v); },
                        $this->_queueOrder
                    )
            ];

        /** Queue param if needed */

        foreach ($this->_queueKey as $v) {
            $params[$v] = $this->{$v};
        }

        /** && now, looping through the "old" records && delete them */

        foreach (
            $this
                ->getExternalContext()
                ->get('orms')
                ->getObjects($this->_ormsClassName, $params) as $i
        ) {
            $i->delete();
        }
    }

    /**
     * Should return the SF2 container
     *
     * @return object
     */

    abstract public function getExternalContext();
}
