<?php

namespace Orms\Tools;

class Inflector
{
    /**
     * Convert a word in to the format for a class name. Converts
     * 'table_name' to 'TableName'
     *
     * @param string  $word  Word to classify
     * @return string $word  Classified word
     */

    public static function classify($word)
    {
        static $cache = array();

        if (!isset($cache[$word]))
        {
            $word = preg_replace('/[$]/', '', $word);
            $classify =
                    preg_replace_callback(
                        '~(_?)([-_])([\w])~',
                        array("self", "classifyCallback"),
                        ucfirst(strtolower($word))
                    );
            $cache[$word] = $classify;
        }
        return $cache[$word];
    }

    /**
     * Callback function to classify a classname properly.
     *
     * @param  array  $matches  An array of matches from a pcre_replace call
     * @return string $string   A string with matches 1 and mathces 3 in upper case.
     */

    public static function classifyCallback($matches)
    {
        return $matches[1] . strtoupper($matches[3]);
    }
}