<?php

namespace Orms\EventDispatcher;

use Orms\Object\DataObject;

/**
 * Description of EventDispatcherInterface
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
interface EventDispatcherInterface
{
    const SAVE = 1;

    const DELETE = 2;
    
    /**
     * Notify Event Dispatcher of a DataObject write
     *
     * @param \Orms\Object\DataObject $object
     * @param int $eventType
     */
    public function notify(DataObject $object, $eventType);
}
