<?php

namespace Orms\Test\Cache;

use Orms\Test\Cache\Logger;
use Orms\Test\Cache\MemoryCache;
use Orms\Test\Cache\TestDataProvider;
use Orms\Test\Mock\ConcreteDataObject;

/**
 * Description of CacheTest
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
class CacheTest extends \PHPUnit_Framework_TestCase
{
    protected $cache;

    public function testCache()
    {
        $provider = $this->loadDataProvider();

        $this->assertTrue($provider->isCacheable());

        $this->assertEquals(
            $provider->get(array('col1' => 1, '_private' => 2)),
            ['URL' => 'http://test']
        );

        $this->assertEquals(
            $provider->getMetadata(),
            ['META' => 1]
        );

        // Check Cache
        $this->assertEquals(
            $this->cache->memory,
            [
                1 =>
                [
                    'Orms\Test\Cache\TestDataProvider42f52ce80af87a68ff0d9ce2918e7f7380cbf8a6' =>
                    [
                        ['URL' => 'http://test'],
                        ['META' => 1]
                    ]
                ]
            ]
        );

        // Change cache memory
        $this->cache->memory =
        [
            1 =>
            [
                'Orms\Test\Cache\TestDataProvider42f52ce80af87a68ff0d9ce2918e7f7380cbf8a6' =>
                [
                    ['URL' => 'http://URL'],
                    ['META' => 2]
                ]
            ]
        ];

        // Check Cache again to be sure to have same result
        $this->assertEquals(
            $provider->get(array('col1' => 1, '_private' => 2)),
            ['URL' => 'http://URL']
        );

        $this->assertEquals(
            $provider->getMetadata(),
            ['META' => 2]
        );

        // Now Clean Cache on save
        $obj = new ConcreteDataObject($provider);
        $obj->col1 = 1;

        $obj->save();

        $this->assertEquals($this->cache->memory, []);

        // Set Cache Again
        $this->assertEquals(
            $provider->get(array('col1' => 1, '_private' => 2)),
            ['URL' => 'http://test']
        );

        $this->assertNotEquals($this->cache->memory, []);

        // Now Clean Cache on delete
        $obj->delete();

        $this->assertEquals($this->cache->memory, []);
    }

    protected function loadDataProvider()
    {
        $this->cache = new MemoryCache();

        return new TestDataProvider
        (
            null,
            array(),
            null,
            new Logger(),
            $this->cache,
            null,
            [
                'Orms\Test\Mock\ConcreteDataObject' => ['Orms\Test\Cache\TestDataProvider']
            ]
        );
    }
}
