<?php

/**
 * File LimitedQueueDataObject Model
 *
 * @package   Orms
 * @version   1.0
 * @author    Yannick Le Guédart
 * @copyright 2013 Overblog
 */

namespace Orms\Object;

use Orms\Object\LimitedQueue;

/**
 * Class LimitedQueueDataObject
 *
 * @package    Orms
 * @subpackage Object
 * @author     Yannick Le Guédart
 */

abstract class LimitedQueueDataObject extends DataObject
{
    use LimitedQueue;

    /** Name of the Orms element class (in the config file) */

    protected $_ormsClassName = null;

    /** Maximum size of each limit according to the key */

    protected $_queueSize = null;

    /** @var $_queueKey key to split queues */

    protected $_queueKey = [];

    /** @var $_queueOrder Order inside a queue */

    protected $_queueOrder = [];
}
