<?php

namespace Orms\Type;

use Orms\Type\Exception;

/**
 * interface pour les définition de types d'objets
 */

interface TypeInterface
{
    /**
     * sets the value of the object after checking
     *
     * @param mixed $value
     *
     * @return object
     */

    public function setValue($value);

    /**
     * Gets an usable value of the object
     *
     * @return mixed
     */

    public function getValue();

    /**
     * Checks if the value provided is valid
     *
     * @param mixed $value
     *
     * @returns boolean
     */

    public function isValid($value);

    /**
     * Returns a string version of the object
     *
     * @return string
     */

    public function __toString();
}