<?php

namespace Orms\Connection;

use Orms\Exception\Exception;

class Postgresql extends \PDO
{
    public function __construct($options = array())
    {
        if (!isset($options['dsn']))
        {
            throw new \Exception("");
        }

        return parent::__construct($options['dsn']);
    }

    /**
     * Pings the current connection
     *
     * @return boolean
     */

    public function ping()
    {
    	try
    	{
    		return (false !== $this->query('SELECT 1;'));
    	}
    	catch(\PDOException $e)
    	{
    		return false;
    	}
    }
}