<?php

namespace Orms\Connection;

/**
 * Description of Handler
 *
 * @author xavier
 */

class Handler
{
    protected $handler;
    protected $type;
    protected $options;

    public function __construct($type, $options = null)
    {
        $this->type = $type;
        $this->options = $options;
    }

    public function getConnection()
    {
        if (is_null($this->handler))
        {
            $class = 
                __NAMESPACE__ . 
                    '\\' . $this->type;

            $this->handler = 
                new $class($this->options);
        }

        return $this->handler;
    }

    public function close()
    {
        unset($this->handler);
    }

    public function ping()
    {
        if (
                ! is_null($this->handler)
                and
                (
                    false 
                    !== 
                    $this->handler->ping()
                )
        )
        {
            return true;
        }
        else
        {
            try 
            {
                $this->reset();

                return true;
            }
            catch(\Exception $e)
            {
                return false;
            }
        }
    }

    public function reset()
    {
        $this->handler = null;

        return $this->getConnection();
    }

    public function __destruct()
    {
        $this->close();
    }
}

