<?php

namespace Orms\Proxy\Dumper;

class OrmsConstructorDumper extends AbstractMethodDumper implements MethodDumperInterface
{
    const METHOD_TEMPLATE = <<<EOF
    private \$registry;

    public function __construct(/* Variable arguments */) {
        \$this->external = new \StdClass();

        \$args = func_get_args();

        if (!count(\$args)) {
            return;
        }

        if (\$args[0] instanceof \Orms\DataProvider\GenericDataProvider) {
            parent::__construct(\$args[0], \$args[1], \$args[2]); // Default Orms entity constructor
            \$data = \$args[1];
        } else {
            // Proxied Orms entity constructor : \$data, \$registry
            if (is_array(\$args[0]) || is_object(\$args[0])) {
                \$this->setFrom(\$args[0]);
            }
            \$this->registry = \$args[1];
            \$data = \$args[0];
        }

        if (!\$this->registry) {
            return;
        }

        parent::__construct(
            \$this->registry->get('entity.provider'),
            \$data,
            \$this->registry->get('entity.links')
        );
    }

    public function setRegistry(\$registry)
    {
        \$this->registry = \$registry;

        if (!\$this->_provider) {
            \$this->_provider = \$registry->get('entity.provider');
        }
        if (!\$this->_linkedElement) {
            \$this->_linkedElement = \$registry->get('entity.links');
        }
    }

    protected function _getLinkedElements(\$linkedClass = null, \$params = array())
    {
        \$entity = parent::_getLinkedElements(\$linkedClass, \$params);
        \$entity->setRegistry(\$this->registry);

        return \$entity;
    }
EOF;

    /**
     * {@inheritsDoc}
     */
    public function dump(\ReflectionMethod $method, $configName)
    {
        return sprintf(self::METHOD_TEMPLATE, $configName, $configName);
    }
}
