# OverBlog NG Libraries #

What is this repository ?
--------------

It's the place where every Symfony related librairies have to go to be shared between project.

Installation and setup
----------------------

Juste add the following lines is your deps file:

    [orms]
        git=git@github.com:ebuzzing/orms.git

    [overblog]
        git=git@github.com:ebuzzing/OverBlog.git

You have now to tell Symfony2 autoloader where to find the API and the files that will be generated. Fire up your text editor and add the following lines to the *app/autoload.php* file:

    #app/autoload.php

        'Orms'             => __DIR__.'/../vendor/orms',
        'Overblog'         => __DIR__.'/../vendor/overblog/src',

Let's register the ORMS in the application kernel:

    #app/AppKernel.php
        // register your bundles
        new Overblog\OrmsBundle\OverblogOrmsBundle(),

You can now define your database settings in your main configuration file. The example below uses the yaml format:

    # app/config/config.yml
    imports:
        - { resource: parameters.ini }
        - { resource: security.yml }
        - { resource: orms.yml }

    # app/config/orms.yml
    overblog_orms:
        connections:
            default:
                type:   Mysql
                options:
                    dsn:        mysql:host=%orms_host%;dbname=%orms_name%
                    username:   %orms_user%
                    password:   %orms_password%

        providers:
            comment:
                connection:       default
                provider_class:   OverblogComment\ModelBundle\DataProvider\Comment
                provider_options:
                    table:   comment

        objects:
            Comment:
                provider:         comment
                object_class:     OverblogComment\ModelBundle\Entity\Comment

The *cnct_name* here is a name for your database connection. You can define several databases connections using different names on different databases, users etc...

    #app/config/orms.yml
        overblog_orms:
            connections:
                default:
                    type:   Mysql
                    options:
                        dsn:        mysql:host=%orms_host%;dbname=%orms_name%
                        username:   %orms_user%
                        password:   %orms_password%
            connections:
                default:
                    type:   Postgresql
                    options:
                        dsn:        pgsql:host=%orms_host%;dbname=%orms_name%
                        username:   %orms_user%
                        password:   %orms_password%

There are two commands bundled with Orms to create Database and inject fixures:
    - You have to create a database creation script located in src/[NameSpace]/ModelBundle/Resources/sql/database_create.sh
    - Then you can call it with:
        #php app/console orms:database:create [NameSpace]

    - You can inject fixtures into database by creating a class in src/[NameSpace]/[BundleName]/Fixtures/[class].php
      Your fixtures classes must implements the Overblog\OrmsBundle\Fixtures\LoaderInterface interface
    - Then you can call it with:
        #php app/console orms:database:create [NameSpace][BundleName] --env=dev
