<?php
namespace Overblog\OrmsBundle\Command;

use Overblog\OrmsBundle\Command\BaseCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Call the database creation script and display the output
 * The script must be located in /ModelBundle/Resources/sql/database_create.sh
 */
class DatabaseCreateCommand extends BaseCommand
{
    protected function configure()
    {
        $this->relativePath = '/Resources/sql/database_create.sh';

        $this->setName('orms:database:create')
          ->setDescription('Create Database and import fixtures');

        $this->addArgument('scriptOptions', InputArgument::OPTIONAL, 'Script creation options');
        $this->addOption('key', 'k', InputOption::VALUE_REQUIRED, 'Bundle search key', 'ModelBundle');
        $this->addOption('onlyBundle', null, InputOption::VALUE_REQUIRED, 'Run only script for this bundle');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $scriptOptions = $input->getArgument('scriptOptions');
        $host          = $this->getContainer()->getParameter('orms_host');

        foreach ($this->getBundlesToRun($input) as $name => $bundle) {
            $scriptPath = $bundle->getPath() . $this->relativePath;

            $output->writeln(sprintf('<info>Found bundle %s</info>', $name));

            if (!file_exists($scriptPath)) {
                $output->writeln("<error>No database creation script found in $scriptPath </error>");
                continue;
            }

            $output->writeln("<info>Running creation script with options </info>");
            $output->writeln("<comment>".($scriptOptions ? $scriptOptions : "No options")."</comment>");

            $commandLine = sprintf(
                'cd %s && %s %s %s 2>&1',
                dirname($scriptPath),
                $scriptPath,
                $host,
                $input->getOption('env'),
                $scriptOptions
            );

            $handle = popen($commandLine, 'r');

            while (($outline = fgets($handle, 4096)) !== false) {
                $output->write('<comment>[out]</comment> '.$outline);
            }

            pclose($handle);
        }
    }
}
