<?php

namespace Overblog\OrmsBundle\Cache;

use Orms\Proxy\Manager;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpKernel\CacheClearer\CacheClearerInterface;

class CacheClearer implements CacheClearerInterface
{
    /**
     * @var Manager
     */
    private $proxyManager;

    /**
     * @param Manager $proxyManager
     */
    public function __construct(Manager $proxyManager)
    {
        $this->proxyManager = $proxyManager;
    }

    /**
     * @param string $cacheDir
     */
    public function clear($cacheDir)
    {
        $fs = new Filesystem();
        $fs->remove($this->proxyManager->getCachePath());
    }
}
