<?php
namespace AlloCine\OrmsBundle\Fixtures;

use AlloCine\OrmsBundle\Fixtures\LoaderInterface;

/**
 * The fixtures objects must implement this interface
 * getObject() returns the object key of the associated object
 * getData()   returns an array of object array definition
 *  to reference an object put a non numeric key
 *  ex:  return array('user1' => array('username' => 'user1', ...)
 *       use $this->getFixturesLoader()->getFixtureObjectReference('user1') to retrieve it
 */

interface ObjectsInterface
{
    
    /**
 * Set the object loading fixtures
 */
public function setFixturesLoader(LoaderInterface $fixturesLoader);

/**
 * Get the object loading fixtures
 */
public function getFixturesLoader();
    
/**
 * Must return the orms object key
 */
public function getObject();

/**
 * Must return an array of data to hydrate the objects
 */
public function getData();
}
