<?php

namespace AlloCine\OrmsBundle\EventDispatcher;

use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Orms\EventDispatcher\EventDispatcherInterface as BaseEventDispatcherInterface;
use Orms\Object\DataObject;
use AlloCine\OrmsBundle\EventDispatcher\DataObjectEvent;

/**
 * Description of OrmsEventDispatcher
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
class OrmsEventDispatcher implements BaseEventDispatcherInterface
{
    /**
     * SF2 Event Dispatcher
     * @var EventDispatcherInterface
     */
    protected $eventDispatcher;

    /**
     * Init Event Dispatcher
     * @param EventDispatcherInterface $eventDispatcher
     */
    public function __construct(EventDispatcherInterface $eventDispatcher)
    {
        $this->eventDispatcher = $eventDispatcher;
    }

    /**
     * Notify Event Dispatcher
     * @param DataObject $object
     * @param int $eventType
     * @return DataObjectEvent
     */
    public function notify(DataObject $object, $eventType)
    {
        $event = new DataObjectEvent($object, $eventType);

        return $this->eventDispatcher->dispatch(
                DataObjectEvent::ORMS_EVENT,
                $event
            );
    }
}
