<?php
namespace AlloCine\OrmsBundle\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\DependencyInjection\ContainerAwareTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Description of BaseCommand
 *
 * @author xavier
 */
abstract class BaseCommand extends Command
{
    use ContainerAwareTrait;

    /**
     * @required
     *
     * @param ContainerInterface $container
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }

    /**
     * Return bundles to run
     * @param InputInterface $input
     * @return array
     */
    protected function getBundlesToRun(InputInterface $input)
    {
        $bundleKey     = $input->hasOption('key') ? $input->getOption('key') : null;
        $onlyBundle    = $input->getOption('onlyBundle');

        $bundles = [];

        foreach ($this->getApplication()->getKernel()->getBundles() as $name => $bundle) {
            if (is_null($bundleKey) || (strpos($name, $bundleKey) !== false) &&
                (is_null($onlyBundle) || (!is_null($onlyBundle) && $onlyBundle == $name))
            ) {
                $bundles[$name] = $bundle;
            }
        }
        return $bundles;
    }
}
