<?php

namespace Overblog\OrmsBundle\Migration;

use Overblog\OrmsBundle\DependencyInjection\OverblogOrmsExtension as Extension;
use Symfony\Component\DependencyInjection\ContainerInterface;

abstract class AbstractMigration
{
    protected $container;

    /**
     * Instanciate
     * @param Orms $orms
     */
    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }

    /**
     * Return PDO handler
     * @param string $name
     * @return \PDO
     */
    public function getConnection($name)
    {
        return $this->container->get(
            sprintf(Extension::CONNECTION_NAME, $name)
        )->getConnection();
    }

    /**
     * Upgrade model
     */
    abstract public function up();

    /**
     * Downgrade model
     */
    abstract public function down();
}

