<?php

namespace AlloCine\OrmsBundle\Request\ParamConverter;

use Orms\Exception\NoRowsFoundException;
use AlloCine\OrmsBundle\Orms\Service;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Request\ParamConverter\ParamConverterInterface;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\Request;

/**
 * OrmsParamConverter.
 */
class OrmsParamConverter implements ParamConverterInterface
{
    /**
     * @var Service
     */
    private $orms;

    /**
     * @param Service $orms
     */
    public function __construct(Service $orms)
    {
        $this->orms = $orms;
    }

    /**
     * {@inheritdoc}
     *
     * @throws \LogicException       When unable to guess how to get a Doctrine instance from the request information
     * @throws NotFoundHttpException When object not found
     */
    public function apply(Request $request, ParamConverter $configuration): bool
    {
        $name    = $configuration->getName();
        $class   = $configuration->getClass();

        $object = $this->find($name, $request->get($name));

        if (null === $object && false === $configuration->isOptional()) {
            throw new NotFoundHttpException(sprintf('%s object not found.', $class));
        }

        $request->attributes->set($name, $object);

        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function supports(ParamConverter $configuration)
    {
        return
            null !== $configuration->getClass()
            &&
            $this->orms->hasObjectConfig($configuration->getName());
    }

    /**
     * @param $object
     * @param $id
     *
     * @return bool
     */
    private function find($object, $id)
    {
        try {
            return $this->orms->getObject($object, $id);
        } catch (NoRowsFoundException $exception) {
            return null;
        }
    }
}
