<?php

namespace AlloCine\OrmsBundle\Proxy;

use Orms\Proxy\Registry;
use Symfony\Component\DependencyInjection\ContainerInterface;

class ContainerRegistry extends Registry
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @param ContainerInterface $container
     */
    public function setContainer(ContainerInterface $container)
    {
        $this->container = $container;
    }

    /**
     * @param  string $name
     *
     * @return mixed
     */
    public function get($name)
    {
        try {
            return parent::get($name);
        } catch (\DomainException $e) {
            return $this->container->get($name);
        }
    }

    /**
     * @return ContainerRegistry
     */
    public function fork()
    {
        $fork = new ContainerRegistry($this->all());
        $fork->setContainer($this->container);

        return $fork;
    }
}
