<?php

namespace Overblog\OrmsBundle;

use Orms\Persistence\AbstractManagerRegistry;
use Symfony\Component\DependencyInjection\ContainerInterface;

class Registry extends AbstractManagerRegistry
{
    private $container;

    /**
     * @param ContainerInterface $container
     * @param array $connections
     * @param array $managers
     */
    public function __construct(ContainerInterface $container, array $connections, array $managers)
    {
        parent::__construct($connections, $managers);
        $this->container = $container;
    }

    /**
     * {@inheritDoc}
     */
    protected function getService($name)
    {
        return $this->container->get($name);
    }
}
