<?php

namespace Overblog\OrmsBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritDoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('overblog_orms');

        $this->addConnectionsSection($rootNode);
        $this->addEntityManagersSection($rootNode);
        $this->addProvidersSection($rootNode);

        return $treeBuilder;
    }

    private function addConnectionsSection(ArrayNodeDefinition $node)
    {
        $node
            ->children()
                ->arrayNode('connections')
                    ->requiresAtLeastOneElement()
                    ->useAttributeAsKey('name')
                    ->prototype('array')
                        ->children()
                            ->scalarNode('driver')->isRequired()->end()
                            ->arrayNode('options')
                                ->children()
                                    // PDO
                                    ->scalarNode('host')->defaultValue('localhost')->end()
                                    ->scalarNode('port')->end()
                                    ->scalarNode('dbname')->end()
                                    ->scalarNode('username')->defaultValue('root')->end()
                                    ->scalarNode('password')->defaultNull()->end()
                                    ->scalarNode('charset')->end()
                                    // SolR
                                    ->scalarNode('hostname')->end()
                                    ->scalarNode('path')->end()
                                    ->scalarNode('timeout')->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;
    }

    private function addEntityManagersSection(ArrayNodeDefinition $node)
    {
        $node
            ->children()
                ->arrayNode('entity_managers')
                    ->requiresAtLeastOneElement()
                    ->useAttributeAsKey('name')
                    ->prototype('array')
                        ->children()
                            ->scalarNode('connection')->isRequired()->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;
    }

    private function addProvidersSection(ArrayNodeDefinition $node)
    {
        $node
            ->children()
                ->arrayNode('providers')
                    ->requiresAtLeastOneElement()
                    ->useAttributeAsKey('name')
                    ->prototype('array')
                        ->children()
                            ->scalarNode('connection')->isRequired()->end()
                            ->scalarNode('provider_class')->isRequired()->end()
                            ->arrayNode('provider_options')
                                ->children()
                                    ->scalarNode('schema')->end()
                                    ->scalarNode('table')->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('objects')
                    ->requiresAtLeastOneElement()
                    ->useAttributeAsKey('name')
                    ->prototype('array')
                        ->children()
                            ->scalarNode('provider')->isRequired()->end()
                            ->scalarNode('object_class')->isRequired()->end()
                            ->arrayNode('links')
                                ->requiresAtLeastOneElement()
                                ->useAttributeAsKey('name')
                                ->prototype('array')
                                    ->children()
                                        ->arrayNode('params')
                                            ->useAttributeAsKey('name')
                                            ->prototype('scalar')->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                            ->arrayNode('links_cache')
                                ->requiresAtLeastOneElement()
                                ->prototype('scalar')->end()
                            ->end()
                            ->scalarNode('manager')->defaultNull()->end()
                            ->arrayNode('proxies')
                                ->addDefaultsIfNotSet()
                                ->children()
                                    ->arrayNode('direct')
                                        ->useAttributeAsKey('id')
                                        ->prototype('array')
                                            ->prototype('variable')
                                            ->end()
                                        ->end()
                                    ->end()
                                    ->arrayNode('uncached')
                                        ->useAttributeAsKey('id')
                                        ->prototype('array')
                                            ->prototype('variable')
                                            ->end()
                                        ->end()
                                    ->end()
                                    ->arrayNode('fetcher')
                                        ->useAttributeAsKey('id')
                                        ->prototype('array')
                                            ->prototype('variable')
                                            ->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;
    }
}
