<?php

namespace Overblog\OrmsBundle;

use Orms\Connection;
use Orms\Driver\DriverRegistryInterface;
use Orms\Logger\QueryLoggerInterface;

class ConnectionFactory
{
    private $registry;
    private $logger;

    /**
     * @param DriverRegistryInterface $registry
     * @param QueryLoggerInterface    $logger
     */
    public function __construct(DriverRegistryInterface $registry, QueryLoggerInterface $logger)
    {
        $this->registry = $registry;
        $this->logger = $logger;
    }

    /**
     * Creates a database connection.
     *
     * @param string $type
     * @param array  $params
     * @return \Orms\Connection
     */
    public function createConnection($type, array $params)
    {
        $driver = $this->registry->get($type);
        $conn = new Connection($params, $driver, $this->logger);

        return $conn;
    }
}
