<?php

namespace AlloCine\OrmsBundle\DataCollector;

use Symfony\Component\HttpKernel\DataCollector\DataCollector;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AlloCine\OrmsBundle\Orms\ServiceInterface;

class OrmsDataCollector extends DataCollector
{
    protected $logger;
    protected $orms;

    public function __construct(ServiceInterface $orm, $logger = null)
    {
        $this->orms        = $orm;
        $this->logger      = $logger;
    }

    public function collect(Request $request, Response $response, \Throwable $exception = null)
    {
        $this->data = [
            'queries' => null !== $this->logger ? $this->logger->queries : [],
            'cachedQueries' => null !== $this->logger ? $this->logger->cachedQueries : [],
        ];
    }

    public function getQueryCount()
    {
        return count($this->data['queries']);
    }

    public function getCachedQueryCount()
    {
        return count($this->data['cachedQueries']);
    }

    public function getQueries()
    {
        return $this->data['queries'];
    }

    public function getTime()
    {
        $time = 0;
        foreach ($this->data['queries'] as $query) {
            $time += $query['executionMS'];
        }

        return $time;
    }

    public function getName()
    {
        return 'orms';
    }

    public function reset()
    {
        $this->data = array();
    }
}
