<?php

namespace Overblog\OrmsBundle\Cache;

use Orms\Cache\CacheInterface;
use Orms\Cache\CacheKey;
use Predis\Client;

/**
 * Redis cache for Orms Objects with Master/Slave Spool
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
class RedisMasterSlaveSpool implements CacheInterface
{
    /**
     * Cache TTL
     */
    protected $ttl;

    /**
     * Redis master instance
     * @var Client
     */
    protected $redisMaster;

    /**
     * Redis slave instance
     * @var Client
     */
    protected $spool;

    /**
     * Constructor
     * @param \Predis\Client $redisMaster
     * @param array $spool
     * @param int $ttl
     */
    public function __construct(Client $redisMaster, array $spool, $ttl = 86400)
    {
        $this->redisMaster = $redisMaster;
        $this->spool = $spool;
        $this->ttl = $ttl;
    }

    /**
     * Get ORMs cache
     * @param \Orms\Cache\CacheKey $key
     * @return array($result, $metadata)
     */
    public function get(CacheKey $key)
    {
        return unserialize(
                $this->redisMaster->hmget(
                    $key->getKey(),
                    $key->getField()
                )[0]
            );
    }

    /**
     * Set ORMs cache
     * @param \Orms\Cache\CacheKey $key
     * @param mixed $value
     * @param mixed $metadata
     * @return boolean
     */
    public function set(CacheKey $key, $value, $metadata)
    {
        $set = $this->redisMaster->hmset(
                $key->getKey(),
                $key->getField(),
                serialize(array($value, $metadata))
            );

        $this->redisMaster->expire($key->getKey(), $this->ttl);

        return $set;
    }

    /**
     * Delete ORMs cache
     * @param \Orms\Cache\CacheKey $key
     * @return int
     */
    public function clean(CacheKey $key)
    {
        foreach($this->spool as $connection)
        {
            $connection->del($key->getKey());
        }

        return true;
    }
}
