<?php

namespace Overblog\OrmsBundle\Cache;

use Orms\Cache\CacheInterface;
use Orms\Cache\CacheKey;
use Predis\Client;

/**
 * Redis cache for Orms Objects
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
class Redis implements CacheInterface
{
    /**
     * Cache TTL
     */
    protected $ttl;

    /**
     * Redis instance
     * @var \Predis\Client
     */
    protected $redisClient;

    /**
     * Constructor
     * @param \Predis\Client $redisClient
     * @param int $ttl
     */
    public function __construct(Client $redisClient, $ttl = 86400)
    {
        $this->redisClient = $redisClient;
        $this->ttl = $ttl;
    }

    /**
     * Get ORMs cache
     * @param \Orms\Cache\CacheKey $key
     * @return array($result, $metadata)
     */
    public function get(CacheKey $key)
    {
        return unserialize(
                $this->redisClient->hmget(
                    $key->getKey(),
                    $key->getField()
                )[0]
            );
    }

    /**
     * Set ORMs cache
     * @param \Orms\Cache\CacheKey $key
     * @param mixed $value
     * @param mixed $metadata
     * @return boolean
     */
    public function set(CacheKey $key, $value, $metadata)
    {
        $set = $this->redisClient->hmset(
                $key->getKey(),
                $key->getField(),
                serialize(array($value, $metadata))
            );

        $this->redisClient->expire($key->getKey(), $this->ttl);

        return $set;
    }

    /**
     * Delete ORMs cache
     * @param \Orms\Cache\CacheKey $key
     * @return int
     */
    public function clean(CacheKey $key)
    {
        return $this->redisClient->del($key->getKey());
    }
}
