<?php

namespace AlloCine\OrmsBundle\EventDispatcher;

use Symfony\Contracts\EventDispatcher\Event;
use Orms\Object\DataObject;

/**
 * Description of DataObjectEvent
 *
 * @author Xavier HAUSHERR <xavier.hausherr@ebuzzing.com>
 */
class DataObjectEvent extends Event
{
    /**
     * The orms.event is throw when DataObject is write
     */
    const ORMS_EVENT = 'orms.event';

    /**
     * This type is thrown when save DataObject
     */
    const SAVE = 1;

    /**
     * This type is delete when save DataObject
     */
    const DELETE = 2;

    /**
     * DataObject
     * @var DataObject
     */
    protected $object;

    /**
     * Event Type
     * @var int
     */
    protected $type;

    /**
     * Init Event
     * @param \Orms\Object\DataObject $object
     * @param int $type
     */
    public function __construct(DataObject $object, $type)
    {
        $this->object = $object;
        $this->type = $type;
    }

    /**
     * Get sent object
     * @return DataObject
     */
    public function getObject()
    {
        return $this->object;
    }

    /**
     * Set Object to send
     * @param \Orms\Object\DataObject $object
     */
    public function setObject(DataObject $object)
    {
        $this->object = $object;
    }

    /**
     * Get Event Type
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set Event Type
     * @param int $type
     */
    public function setType($type)
    {
        $this->type = $type;
    }

    /**
     * Get Object Class
     * @return string
     */
    public function getObjectClass()
    {
        return get_class($this->object);
    }
}
