<?php
namespace AlloCine\OrmsBundle\Command;

use AlloCine\OrmsBundle\Command\BaseCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Call the database reinit script and display the output
 * The script must be located in /ModelBundle/Resources/sql/database_create.sh
 */
class DatabaseReinitCommand extends BaseCommand
{
    protected function configure()
    {
        $this->relativePath = '/Resources/sql/database_reinit.sh';

        $this
            ->setName('orms:database:reinit')
            ->setDescription('Reinit database')
            ->addArgument(
                'scriptOptions',
                InputArgument::OPTIONAL,
                'script creation options'
            );

        $this->addOption('key', 'k', InputOption::VALUE_REQUIRED, 'Bundle search key', 'ModelBundle');
        $this->addOption('onlyBundle', null, InputOption::VALUE_REQUIRED, 'Run only script for this bundle');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $scriptOptions = $input->getArgument('scriptOptions');
        $host          = $this->container->getParameter('orms_host');

        foreach ($this->getBundlesToRun($input) as $name => $bundle) {
            $scriptPath = $bundle->getPath() . $this->relativePath;

            $output->writeln(sprintf('<info>Found bundle %s</info>', $name));

            // Vérification de l'existaence du script

            if (!file_exists($scriptPath)) {
                $output->writeln("<error>No database creation script found in $scriptPath </error>");
                continue;
            }

            $output->write("<info>Running reinit script with options </info>");
            $output->writeln(
                "<comment>" .
                    ($scriptOptions ? $scriptOptions : "No options") .
                    "</comment>"
            );

            $commandLine =
                sprintf(
                    'cd %s && %s %s %s 2>&1',
                    dirname($scriptPath),
                    $scriptPath,
                    $host,
                    $input->getOption('env'),
                    $scriptOptions
                );

            $handle = popen($commandLine, 'r');

            while (($outline = fgets($handle, 4096)) !== false) {
                $output->write('<comment>[out]</comment> ' . $outline);
            }

            pclose($handle);
        }

        return 0;
    }
}
